import { viewAllTenantUser } from "./initTenantUser.js";

export function initAction() {
	/*******************************************************************************************
						VALIDASI INPUT DATA TENANT USER (TAMBAH)
	*******************************************************************************************/
	$("form[name='add-tenant-user']").validate({
		rules: {
			tenant_id: "required",
			user_id: "required",
		},
		messages: {
			tenant_id: "Tenant harus dipilih",
			user_id: "User harus dipilih",
		},
		submitHandler: function (form) {
			const formData = new FormData(form);
			$.ajax({
				url: rootApp + "api/tenant-user/add",
				type: "POST",
				data: formData,
				dataType: "json",
				contentType: false,
				processData: false,
				success: function (res) {
					$("#modal_form_add").modal("hide");
					pnotifySuccess(res.status, res.message);
					$("form[name='add-tenant-user']")[0].reset();
					viewAllTenantUser();
				},
				error: function (request, error) {
					pnotifyError("Error", JSON.stringify(request.statusText));
				},
			});
		},
	});

	/*******************************************************************************************
									EDIT TENANT USER
	*******************************************************************************************/
	$("#table-body-tenant-user").on("click", ".btn-edit", function () {
		const id = $(this).data("id");
		$.ajax({
			url: rootApp + "api/tenant_user/get_by_id",
			type: "GET",
			data: { id: id },
			dataType: "json",
			success: function (res) {
				const data = res.data;
				$("#modal_form_edit").modal("show");

				$("#tenant_user_id").val(data.tenant_user_id);
				$("#edit_tenant_id").val(data.tenant_id);
				$("#edit_user_id").val(data.user_id);
			},
			error: function (request, error) {
				pnotifyError("Error", JSON.stringify(request.statusText));
			},
		});
	});

	/*******************************************************************************************
									VALIDASI FORM EDIT
	*******************************************************************************************/
	$("form[name='edit-tenant-user']").validate({
		rules: {
			tenant_id: "required",
			user_id: "required",
		},
		messages: {
			tenant_id: "Tenant harus dipilih",
			user_id: "User harus dipilih",
		},
		submitHandler: function (form) {
			$.ajax({
				url: rootApp + "api/tenant-user/edit",
				type: "POST",
				data: $("#edit-tenant-user").serialize(),
				dataType: "json",
				success: function (res) {
					$("#modal_form_edit").modal("hide");
					pnotifySuccess(res.status, res.message);
					viewAllTenantUser();
				},
				error: function (request, error) {
					pnotifyError("Error", JSON.stringify(request.statusText));
				},
			});
		},
	});

	/*******************************************************************************************
									DELETE TENANT USER
	*******************************************************************************************/
	$("#table-body-tenant-user").on("click", ".btn-delete", function () {
		const id = $(this).data("id");

		if (!confirm("Yakin ingin menghapus relasi tenant-user ini?")) return;

		$.ajax({
			url: rootApp + "api/tenant-user/delete",
			type: "POST",
			data: { tenant_user_id: id },
			dataType: "json",
			success: function (res) {
				pnotifySuccess(res.status, res.message);
				viewAllTenantUser();
			},
			error: function (request, error) {
				pnotifyError("Error", JSON.stringify(request.statusText));
			},
		});
	});
}
