var _initTableOwner = function (className) {
	// Initialize
	$("." + className).DataTable({
		autoWidth: false,
		order: [[0, "asc"]],
		dom: '<"datatable-header"fl><"datatable-scroll-lg"t><"datatable-footer"ip>',
		language: {
			search: "<span>Filter:</span> _INPUT_",
			searchPlaceholder: "Type to filter...",
			lengthMenu: "<span>Show:</span> _MENU_",
			paginate: {
				first: "First",
				last: "Last",
				next: $("html").attr("dir") == "rtl" ? "&larr;" : "&rarr;",
				previous: $("html").attr("dir") == "rtl" ? "&rarr;" : "&larr;",
			},
		},
		lengthMenu: [25, 50, 75, 100],
		displayLength: 25,
		drawCallback: function (settings) {
			var api = this.api();

			// Initializw Select2
			if (!$().select2) {
				console.warn("Warning - select2.min.js is not loaded.");
				return;
			}
			$(".form-control-select2").select2({
				width: 150,
				minimumResultsForSearch: Infinity,
			});
		},
	});
};

export function _uniform() {
	var _componentUniform = function () {
		if (!$().uniform) {
			console.warn("Warning - uniform.min.js is not loaded.");
			return;
		}

		// Default initialization
		$(".form-check-input-styled").uniform();

		//
		// Contextual colors
		//

		// Primary
		$(".form-check-input-styled-primary").uniform({
			wrapperClass: "border-primary-600 text-primary-800",
		});

		// Danger
		$(".form-check-input-styled-danger").uniform({
			wrapperClass: "border-danger-600 text-danger-800",
		});

		// Success
		$(".form-check-input-styled-success").uniform({
			wrapperClass: "border-success-600 text-success-800",
		});

		// Warning
		$(".form-check-input-styled-warning").uniform({
			wrapperClass: "border-warning-600 text-warning-800",
		});

		// Info
		$(".form-check-input-styled-info").uniform({
			wrapperClass: "border-info-600 text-info-800",
		});

		// Custom color
		$(".form-check-input-styled-custom").uniform({
			wrapperClass: "border-indigo-600 text-indigo-800",
		});
	};
}

export function viewAllTenantUser() {
	$.ajax({
		url: rootApp + "api/tenant-user",
		type: "GET",
		dataType: "json",
		success: function (res) {
			let html = "";
			res.data.forEach((item, index) => {
				html += `
					<tr>
						<td>${index + 1}</td>
						<td>${item.tenant_name}</td>
						<td>${item.user_full_name ?? "-"}</td>
						<td>${item.user_email ?? "-"}</td>
						<td>${item.user_phone_number ?? "-"}</td>
						<td>
							<button class="btn btn-sm btn-primary btn-edit" data-id="${item.tenant_user_id}">Edit</button>
							<button class="btn btn-sm btn-danger btn-delete" data-id="${item.tenant_user_id}">Hapus</button>
						</td>
					</tr>
				`;
			});
			$("#table-body-tenant-user").html(html);
		},
		error: function (request, error) {
			console.log("Error:", error);
		},
	});
}
